/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.client.render.infobar.IDataModel;
import dev.toma.gunsrpg.client.render.infobar.QuestDisplayDataModel;
import dev.toma.gunsrpg.client.render.infobar.TextElement;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.common.quests.condition.QuestConditions;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestConditionTierScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.reward.QuestReward;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardList;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardManager;
import dev.toma.gunsrpg.common.quests.trigger.ITriggerHandler;
import dev.toma.gunsrpg.common.quests.trigger.ITriggerResponder;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.common.quests.trigger.TriggerContext;
import dev.toma.gunsrpg.common.quests.trigger.TriggerResponseStatus;
import dev.toma.gunsrpg.util.properties.IPropertyHolder;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import dev.toma.gunsrpg.util.properties.PropertyContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public abstract class Quest<D extends IQuestData> {
    private static final ITextComponent QUEST_COMPLETED = new TranslationTextComponent("quest.completed").func_240699_a_(TextFormatting.GREEN);
    private static final ITextComponent QUEST_FAILED = new TranslationTextComponent("quest.failed").func_240699_a_(TextFormatting.RED);
    private final Multimap<Trigger, TriggerContext> triggerListeners = ArrayListMultimap.create();
    private final QuestScheme<D> scheme;
    private final IQuestCondition[] conditions;
    private final int rewardTier;
    private final UUID uuid;
    private final LazyOptional<IDataModel> displayModel = LazyOptional.of(this::buildDataModel);
    private final IPropertyHolder initialProperties = PropertyContext.create();
    protected PlayerEntity player;
    protected QuestReward reward;
    protected QuestStatus status = QuestStatus.CREATED;

    public Quest(QuestScheme<D> scheme, UUID traderId) {
        this.scheme = scheme;
        this.uuid = traderId;
        QuestConditionTierScheme tierScheme = scheme.getConditionTierScheme();
        QuestConditionTierScheme.Result result = tierScheme.getModifiedConditions();
        this.rewardTier = scheme.getTier() + result.getTierModifier();
        IQuestCondition[] tieredConditions = result.getConditions();
        IQuestConditionProvider<?>[] schemeConditions = scheme.getQuestConditions();
        IQuestCondition[] allConditions = new IQuestCondition[tieredConditions.length + schemeConditions.length];
        System.arraycopy(tieredConditions, 0, allConditions, 0, tieredConditions.length);
        for (int i = 0; i < schemeConditions.length; ++i) {
            Object condition = schemeConditions[i].makeConditionInstance();
            allConditions[tieredConditions.length + i] = condition;
        }
        this.conditions = allConditions;
        this.registerAllTriggers();
    }

    public Quest(QuestDeserializationContext<D> context) {
        this.scheme = context.getScheme();
        this.uuid = context.getTraderId();
        this.conditions = context.getConditions();
        this.rewardTier = context.getRewardTier();
        this.status = context.getStatus();
        QuestReward reward = context.getReward();
        if (reward != null) {
            this.reward = reward;
        }
        this.registerAllTriggers();
    }

    public abstract void registerTriggers(ITriggerRegistration var1);

    public D getActiveData() {
        return this.scheme.getData();
    }

    public void assign(PlayerEntity player) {
        this.player = player;
        this.savePlayerStatusProperties(player);
        if (this.reward == null) {
            IPlayerData data = PlayerData.getUnsafe(player);
            IAttributeProvider provider = data.getAttributes();
            int rewardChoices = provider.getAttribute(Attribs.QUEST_VISIBLE_REWARD).intValue();
            QuestSystem system = GunsRPG.getModLifecycle().quests();
            QuestRewardManager manager = system.getRewardManager();
            QuestRewardList rewardList = manager.getTieredRewards(this.rewardTier);
            QuestReward.Options options = new QuestReward.Options().items(1).choiceCount(rewardChoices).setUnique();
            this.reward = QuestReward.generate(rewardList, options, player);
        }
    }

    public UUID getOriginalAssignerId() {
        return this.uuid;
    }

    public void tickQuest(PlayerEntity player) {
        float health = player.func_110143_aJ();
        int food = player.func_71024_bL().func_75116_a();
        float savedHealth = this.initialProperties.getProperty(QuestProperties.HEALTH_STATUS).floatValue();
        int savedFood = this.initialProperties.getProperty(QuestProperties.FOOD_STATUS);
        if (health < savedHealth) {
            this.initialProperties.setProperty(QuestProperties.HEALTH_STATUS, Float.valueOf(health));
        }
        if (food < savedFood) {
            this.initialProperties.setProperty(QuestProperties.FOOD_STATUS, food);
        }
    }

    public void onCompleted(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(SoundEvents.field_187802_ec, SoundCategory.MASTER, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.75f, 1.0f));
            serverPlayer.func_241151_a_(QUEST_COMPLETED, ChatType.GAME_INFO, Util.field_240973_b_);
            PlayerData.get(player).ifPresent(data -> data.getQuests().getTraderStandings().questFinished(this.uuid, this));
        }
    }

    public void onFailed(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(ModSounds.USE_AVENGE_ME_FRIENDS, SoundCategory.MASTER, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.75f, 1.0f));
            serverPlayer.func_241151_a_(QUEST_FAILED, ChatType.GAME_INFO, Util.field_240973_b_);
            PlayerData.get(player).ifPresent(data -> {
                IQuests quests = data.getQuests();
                quests.getTraderStandings().questFailed(this.uuid, this);
                quests.clearActiveQuest();
            });
        }
    }

    public void trigger(Trigger trigger, IPropertyReader reader) {
        if (this.getStatus() != QuestStatus.ACTIVE) {
            return;
        }
        this.initialProperties.moveContents((IPropertyHolder)reader);
        Collection contexts = this.triggerListeners.get((Object)trigger);
        if (contexts != null) {
            TriggerResponseStatus response = TriggerResponseStatus.OK;
            for (TriggerContext context : contexts) {
                TriggerResponseStatus status = context.getResponse(trigger, reader);
                if (status.ordinal() <= response.ordinal()) continue;
                response = status;
            }
            switch (response) {
                case OK: {
                    for (TriggerContext context : contexts) {
                        context.handleSuccess(trigger, reader);
                    }
                    break;
                }
                case FAIL: {
                    this.setStatus(QuestStatus.FAILED);
                }
            }
            switch (this.status) {
                case COMPLETED: {
                    this.onCompleted(this.player);
                    break;
                }
                case FAILED: {
                    this.onFailed(this.player);
                }
            }
        }
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("scheme", (INBT)this.scheme.serialize());
        ListNBT conditionList = new ListNBT();
        Arrays.stream(this.conditions).map(QuestConditions::saveConditionToNbt).forEach(arg_0 -> conditionList.add(arg_0));
        nbt.func_218657_a("conditions", (INBT)conditionList);
        nbt.func_186854_a("createdBy", this.uuid);
        nbt.func_74768_a("rewardTier", this.rewardTier);
        if (this.reward != null) {
            nbt.func_218657_a("reward", (INBT)this.reward.toNbt());
        }
        nbt.func_74768_a("status", this.status.ordinal());
        CompoundNBT internalData = new CompoundNBT();
        this.writeQuestData(internalData);
        nbt.func_218657_a("internalData", (INBT)internalData);
        return nbt;
    }

    public QuestScheme<D> getScheme() {
        return this.scheme;
    }

    public IQuestCondition[] getConditions() {
        return this.conditions;
    }

    public int getRewardTier() {
        return this.rewardTier;
    }

    public void setStatus(QuestStatus status) {
        this.status = status;
    }

    public QuestStatus getStatus() {
        return this.status;
    }

    public QuestReward getReward() {
        return this.reward;
    }

    @OnlyIn(value=Dist.CLIENT)
    public LazyOptional<IDataModel> getDisplayModel() {
        return this.displayModel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quest quest = (Quest)o;
        return this.getScheme().equals(quest.getScheme());
    }

    public int hashCode() {
        return this.getScheme().hashCode();
    }

    protected boolean overrideFailureFromCondition() {
        return false;
    }

    protected void writeQuestData(CompoundNBT nbt) {
    }

    protected void readQuestData(CompoundNBT nbt) {
    }

    protected void savePlayerStatusProperties(PlayerEntity player) {
        this.initialProperties.setProperty(QuestProperties.FOOD_STATUS, player.func_71024_bL().func_75116_a());
        this.initialProperties.setProperty(QuestProperties.HEALTH_STATUS, Float.valueOf(player.func_110143_aJ()));
    }

    protected void trySyncClient() {
        if (this.player == null) {
            return;
        }
        PlayerData.get(this.player).ifPresent(data -> data.sync(4));
    }

    protected void fillDataModel(QuestDisplayDataModel model) {
        model.addQuestHeader(this);
    }

    private IDataModel buildDataModel() {
        QuestDisplayDataModel dataModel = new QuestDisplayDataModel();
        if (this.getStatus() == QuestStatus.COMPLETED) {
            dataModel.addElement(new TextElement((ITextComponent)new TranslationTextComponent("quest.task.completed").func_240699_a_(TextFormatting.GREEN).func_240699_a_(TextFormatting.BOLD)));
            dataModel.addElement(new TextElement((ITextComponent)new TranslationTextComponent("quest.task.claim_reward")));
        } else {
            this.fillDataModel(dataModel);
        }
        return dataModel;
    }

    private void registerAllTriggers() {
        for (IQuestCondition condition : this.conditions) {
            QuestConditionProviderType<?> conditionType = condition.getProviderType().getType();
            Set<Trigger> triggerSet = conditionType.getTriggerSet();
            for (Trigger trigger2 : triggerSet) {
                ITriggerResponder responder2 = (trig, reader) -> this.handleQuestCondition(conditionType, condition, reader);
                ITriggerHandler handler2 = condition instanceof ITriggerHandler ? (ITriggerHandler)((Object)condition) : ITriggerHandler.NONE;
                TriggerContext context = TriggerContext.make(responder2, handler2);
                this.triggerListeners.put((Object)trigger2, (Object)context);
            }
        }
        this.registerTriggers((trigger, responder, handler) -> this.triggerListeners.put((Object)trigger, (Object)TriggerContext.make(responder, handler)));
    }

    private TriggerResponseStatus handleQuestCondition(QuestConditionProviderType<?> type, IQuestCondition condition, IPropertyReader reader) {
        boolean wasValid = condition.isValid(this.player, reader);
        return wasValid ? TriggerResponseStatus.OK : (type.shouldFailQuest() && !this.overrideFailureFromCondition() ? TriggerResponseStatus.FAIL : TriggerResponseStatus.PASS);
    }

    public String toString() {
        return this.scheme.getQuestId().toString();
    }

    public static interface ITriggerRegistration {
        public void addEntry(Trigger var1, ITriggerResponder var2, ITriggerHandler var3);
    }
}

